<?php 
include 'core/init.php';
include 'includes/overall/header.php'; 
?>

<?php 

if(servers_count() < 1) {
	echo "<br />";
	include 'includes/overall/footer.php'; 
	die();
}
?>

<div class="panel panel-default">
	<div class="panel-body">
		<div>
			<div class="pull-right" style="display:inline;">
				<?php
				if($settings['facebook'] !== 'false') echo '<a href="http://facebook.com/' . $settings['facebook'] . '" class="btn btn-primary btn-small">Follow us on Facebook <i class="icon-white icon-share"></i></a>&nbsp;';
				if($settings['twitter'] !== 'false') echo '<a href="http://twitter.com/' . $settings['twitter'] . '" class="btn btn-info btn-small">Follow us on Twitter <i class="icon-white icon-share-alt"></i></a>';
				?>
				<div class="dropdown" style="display:inline;">
					<a class="dropdown-toggle btn btn-default btn-small"  data-toggle="dropdown" href="#">&nbsp; Sort by <span class="caret"></span> &nbsp;</a>
					<ul class="dropdown-menu" role="menu" aria-labelledby="dLabel" >
						<li><a href="index.php?sort=players">Players</a></li>
						<li><a href="index.php?sort=status">Status</a></li>
						<li><a href="index.php">Votes</a></li>
					</ul>
				</div>
				<div class="dropdown" style="display:inline;">
					<a class="dropdown-toggle btn btn-default btn-small"  data-toggle="dropdown" href="#">&nbsp; Version <span class="caret"></span> &nbsp;</a>
					<ul class="dropdown-menu" role="menu" aria-labelledby="dLabel" >
						<?php 
						$result = mysql_query("SELECT DISTINCT `serverVersion` FROM `servers`");
						while($row = mysql_fetch_array($result)){
							echo "<li><a href='index.php?version=" . $row['serverVersion'] . "'>" . $row['serverVersion'] . "</a></li>";
						}
						?>
					</ul>
				</div>
				<div class="dropdown" style="display:inline;">
					<a class="dropdown-toggle btn btn-default btn-small"  data-toggle="dropdown" href="#">&nbsp; Country <span class="caret"></span> &nbsp;</a>
					<ul class="dropdown-menu" role="menu" aria-labelledby="dLabel" >
						<?php 
						$result = mysql_query("SELECT DISTINCT `country` FROM `servers`");
						while($row = mysql_fetch_array($result)){
							echo "<li><a href='index.php?country=" . $row['country'] . "'>" . $row['country'] . "</a></li>";
						}
						?>
					</ul>
				</div>
				<div class="dropdown" style="display:inline;">
					<a class="dropdown-toggle btn btn-default btn-small"  data-toggle="dropdown" href="#">&nbsp; Category <span class="caret"></span> &nbsp;</a>
					<ul class="dropdown-menu" role="menu" aria-labelledby="dLabel" >
						<?php 
						$result = mysql_query("SELECT DISTINCT `name` FROM `categories`");
						while($row = mysql_fetch_array($result)){
							echo "<li><a href='index.php?category=" . $row['name'] . "'>" . $row['name'] . "</a></li>";
						}
						?>
					</ul>
				</div>
			</div>
			<h2>Minecraft Servers&nbsp;</h2>
		</div>

<?php if(!empty($settings['news_message'])) { ?>
<div class="alert alert-info">
	<button type="button" class="close" data-dismiss="alert">&times;</button>
	<strong>News:</strong> <?php echo $settings['news_message']; ?>
</div>
<?php } ?>
<hr />


<?php
//Pagination
$page = 1;
if(isset($_GET['page'])) { $page = $_GET['page']; } 
$limitT 		= (($page * $settings['pagination']) - $settings['pagination']); 
$pagination = $settings['pagination'];
//

$rank = 1;
if($page > 1) $rank = $page * $pagination - $pagination + 1;

$order = "`votes` DESC";
if(isset($_GET['sort'])){
	switch($_GET['sort']){
		case "players" : $order = "`Players` DESC"; break;
		case "status"  : $order = "`status` DESC";  break;
	}
}

$offline_where = $category_filter = $version_filter = $country_filter = NULL;
if($settings['show_offline_servers'] == '0') $offline_where = "AND `status` = 1"; 
	
if(isset($_GET['version'])){
	$_GET['version'] = sanitize($_GET['version']);
	$version_filter = "AND `serverVersion` = '" . $_GET['version'] . "'";
}
if(isset($_GET['category'])){
	$_GET['category'] = sanitize($_GET['category']);
	$category_id = mysql_result(mysql_query("SELECT `category_id` FROM `categories` WHERE `name` = '{$_GET['category']}'"),0);
	$category_filter = "AND `category_id` LIKE '%{$category_id}%'";
}
if(isset($_GET['country'])){
	$_GET['country'] = sanitize($_GET['country']);
	$country_filter = "AND `country` = '" . $_GET['country'] . "'";
}

$result  = mysql_query("SELECT * FROM `servers` WHERE `disabled` = '0' {$category_filter} {$country_filter} {$version_filter}{$offline_where} ORDER BY `vip` DESC, {$order} LIMIT $limitT, $pagination");
while ($server_data = mysql_fetch_array($result)) {
	$server_id = $server_data['id'];
	$info = array();

	if($server_data['banner'] != '') {

		$banner = (file_exists("banners/" . $server_data['banner'])) ? "banners/" . $server_data['banner'] : $server_data['banner'];

	} else $banner = "includes/img/1.png";



	//Check if server was already queried in the last X seconds
	// if yes -> get the cache data from database
	// if no  -> recheck
	
	if($server_data['cache_time'] > time() - $settings['server_cache'] || $settings['disable_query'] == "1"){
		$info['status'] = $server_data['status'];
		$info['Players'] = $server_data['Players'];
		$info['MaxPlayers'] = $server_data['MaxPlayers'];
		$info['serverVersion'] = $server_data['serverVersion'];
		if($info['status'] == 1){ $status = 1; } else { $status = 0; }
	} else {
		$Query = new MinecraftQuery($server_data['ip'], $server_data['port']);

		if($server_data['protocol'] == 1){
			$info = $Query->QueryNew();
		} else {
			$info = $Query->QueryOld();
		}

		//Check status of the server
		if($Query->getStatus() !== false){ $status = 1; } else { $status = 0; }

		//Update the cache
		if($status == 1) {
			mysql_query("UPDATE `servers` SET `status` = '$status', `serverVersion` = '{$info['serverVersion']}', `Players` = '{$info['Players']}', `MaxPlayers` = '{$info['MaxPlayers']}', `cache_time` = unix_timestamp() WHERE `id` = '$server_id'");
		}else{
			mysql_query("UPDATE `servers` SET `status` = '$status', `Players` = '0', `cache_time` = unix_timestamp()  WHERE `id` = '$server_id'");
		}
	
	}
if($status == 0 && $settings['show_offline_servers'] == '0') { continue; }
?>		
<table class="table list <?php if($server_data['vip'] == "1") echo 'vip-server'; ?>" style="table-layout: fixed;">
	<tbody>
		<tr>
			<td style="width:5%;text-align:center;">
				<?php if($server_data['vip'] == "1"){ ?>
				<span class="glyphicon glyphicon-star"></span>
				<?php } else { ?>
				<span class="badge"><?php echo $rank; ?></span>
				<?php } ?>
			</td>
			<td style="width:55%">
				<a href="server.php?id=<?php echo $server_data['id']; ?>">
					<img src="<?php echo $banner; ?>" />
				</a>

				<br />
				<?php if($status == 1) echo "<span class='label label-success'>Online</span>"; else echo "<span class='label label-warning'>Offline</span>"; ?>
				&nbsp;
				<a href="index.php?version=<?php if($status == 1) echo $info['serverVersion']; else echo $server_data['serverVersion']; ?>"><span class="label label-info"><?php if($status == 1) echo $info['serverVersion']; else echo $server_data['serverVersion']; ?></span></a>
				&nbsp;
				<a href="server.php?id=<?php echo $server_data['id']; ?>">
					<span class="label label-primary" style="font-size: 80%;"><?php echo strtolower($server_data['ip']); if($server_data['port'] !== "25565") echo ":".$server_data['port']; ?></span>
				</a>	
				&nbsp;
				<a href="index.php?country=<?php echo $server_data['country']; ?>"><?php if($server_data['country'] !== 'XX') { ?><img src="includes/locations/<?php echo $server_data['country']; ?>.png" alt="country" title="<?php echo $server_data['country']; ?>"/><?php } ?></a>
				&nbsp;

				<?php if(logged_in() && is_admin($session_user_id)) { ?>
				<span class="opacity">
				<a href="adm_servers_management.php?vip=<?php echo $server_id; ?>">
					<span class="label label-info">
						<span class="glyphicon glyphicon-star"></span> VIP
					</span>
				</a>&nbsp;
				
				<a href="adm_servers_management.php?status=<?php echo $server_id; ?>">
					<span class="label label-danger">
						<span class="glyphicon glyphicon-off "></span> Disable
					</span>
				</a>&nbsp;
				
				<a href="adm_servers_management.php?delete=<?php echo $server_id; ?>">
					<span class="label label-danger">
						<span class="glyphicon glyphicon-remove"></span> Delete
					</span>
				</a>
				</span>	
				<?php } ?>

			</td>
			<td style="width:20%">
				<table class="table-reset">
					<tr>
						<th>Players</th>
						<td><span class="label label-success"><?php if($status == 1){echo $info['Players'] . "/" . $info['MaxPlayers']; } else { echo "0"; } ?></span></td>
					</tr>
					<tr>
						<th>Votes</th>
						<td><span class="label label-info"><?php echo $server_data['votes']; ?></span></td>
					</tr>
				</table>
			</td>
			<td style="width: 20%;word-break:break-all;">
				<strong>Categories</strong><br />
				<?php get_categories($server_id); ?>
			</td>
		</tr>	
	</tbody>
</table>
<br />
<?php $rank++;} ?>
</div>
</div>

<?php
include "pagination.php";
include 'includes/overall/footer.php'; 
?>